/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.toolkit.VWTaskBlockingPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.OperatingSystem;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class VWTaskUtil {
    private static int m_osType;
    public static int OS_TYPE_UNDEFINED;
    public static int OS_TYPE_WINDOWS;
    public static int OS_TYPE_AIX;
    public static int OS_TYPE_HP;
    public static int OS_TYPE_SOLARIS;
    private static Logger logger;
    private static String m_className;

    private VWTaskUtil() {
    }

    public static int getOSType() {
        return OperatingSystem.getType();
    }

    public static void showWaitCursor(final boolean bWait, final Component c) {
        Runnable doShowWaitCursor = new Runnable(){

            public void run() {
                JRootPane rootPane = VWTaskUtil.rootPaneForComponent(c);
                if (rootPane == null) {
                    return;
                }
                Component glassPane = rootPane.getGlassPane();
                if (!(glassPane instanceof VWTaskBlockingPanel)) {
                    glassPane = new VWTaskBlockingPanel();
                    rootPane.setGlassPane(glassPane);
                }
                if (bWait) {
                    Cursor cursorWait = Cursor.getPredefinedCursor(3);
                    rootPane.setCursor(cursorWait);
                    glassPane.setCursor(cursorWait);
                    glassPane.setVisible(true);
                } else {
                    Cursor cursorDefault = Cursor.getPredefinedCursor(0);
                    glassPane.setVisible(false);
                    glassPane.setCursor(cursorDefault);
                    rootPane.setCursor(cursorDefault);
                }
                glassPane.invalidate();
                rootPane.validate();
            }
        };
        VWTaskUtil.performUIOperation(doShowWaitCursor, true);
    }

    public static JRootPane rootPaneForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                return (JRootPane)p;
            }
            if (comp instanceof JFrame) {
                return ((JFrame)comp).getRootPane();
            }
            if (!(comp instanceof JDialog)) continue;
            return ((JDialog)comp).getRootPane();
        }
        return null;
    }

    public static void performUIOperation(Runnable operation) {
        VWTaskUtil.performUIOperation(operation, true);
    }

    public static void performUIOperation(Runnable operation, boolean wait) {
        try {
            if (VWTaskCore.getInstance().isAutoMode() || wait && SwingUtilities.isEventDispatchThread()) {
                operation.run();
            } else if (wait) {
                SwingUtilities.invokeAndWait(operation);
            } else {
                SwingUtilities.invokeLater(operation);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public static int parseInt(String strInt, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(strInt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean isEqualToArrayElement(Object object, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(object) || !object.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static void appendArrayToList(List list, Object[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
    }

    public static Object[] appendArrays(Object[] arr1, Object[] arr2, Class elementType) {
        Object[] result = (Object[])Array.newInstance(elementType, arr1.length + arr2.length);
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    public static ArrayList mapValuesToList(HashMap map) {
        ArrayList list = new ArrayList(map.size());
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public static HashMap createHashMap(Object[] keys) {
        return VWTaskUtil.createHashMap(keys, false);
    }

    public static HashMap createHashMap(Object[] keys, boolean useKeyAsValue) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], null);
        }
        return map;
    }

    public static HashMap createHashMap(ArrayList keys) {
        return VWTaskUtil.createHashMap(keys, false);
    }

    public static HashMap createHashMap(ArrayList keys, boolean useKeyAsValue) {
        return VWTaskUtil.createHashMap(keys.toArray(), useKeyAsValue);
    }

    public static ArrayList createList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static void removeObjectsFromSortedList(List list, Object[] objs, Comparator c) {
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            int index = Collections.binarySearch(list, objs[i], c);
            if (index < 0) continue;
            list.remove(index);
        }
    }

    public static String backSlashToForwardSlash(String path) {
        StringBuffer buffer = new StringBuffer(path);
        for (int index = 0; index < buffer.length(); ++index) {
            if (buffer.charAt(index) != '\\') continue;
            buffer.replace(index, index + 1, "/");
        }
        return buffer.toString();
    }

    public static String removeTrailingSlash(String path) {
        if (path != null && path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String addQuotes(String line) {
        StringBuffer buffer = new StringBuffer(line);
        if (!line.startsWith("\"")) {
            buffer.insert(0, "\"");
        }
        if (!line.endsWith("\"")) {
            buffer.append("\"");
        }
        return buffer.toString();
    }

    public static String getWindowsShortPath(String path) {
        return VWTaskUtil.getWindowsShortPath(path, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWindowsShortPath(String path, HashMap map) {
        try {
            if (VWTaskUtil.getOSType() != OS_TYPE_WINDOWS) {
                return path;
            }
            if (path == null) {
                return path;
            }
            File file = new File(path).getAbsoluteFile();
            if (file.getPath().indexOf(" ") < 0) {
                return file.getPath();
            }
            if (map != null && map.containsKey(file.getPath())) {
                return (String)map.get(file.getPath());
            }
            File parentFile = file.getParentFile();
            String parentPath = "";
            if (parentFile != null && !(parentPath = VWTaskUtil.getWindowsShortPath(parentFile.getPath(), map)).endsWith(File.separator)) {
                parentPath = parentPath + File.separator;
            }
            String shortName = null;
            if (file.getName().indexOf(" ") > 0) {
                StringBuffer command = new StringBuffer("cmd /c dir /X ");
                if (file.isDirectory()) {
                    command.append(VWTaskUtil.addQuotes(parentFile.getPath()));
                } else {
                    command.append(VWTaskUtil.addQuotes(file.getPath()));
                }
                VWTaskProcessResult result = VWTaskProcessLauncher.exec(command.toString(), null, true, false, null);
                if (result != null) {
                    StringTokenizer lines = new StringTokenizer(result.getOutput(), "\n", false);
                    String ucaseFileName = file.getName().toUpperCase();
                    while (lines.hasMoreTokens() && shortName == null) {
                        String line = lines.nextToken().toUpperCase();
                        if (line.indexOf(ucaseFileName) <= 0) continue;
                        String temp = line.substring(0, line.indexOf(ucaseFileName)).trim();
                        shortName = temp.substring(temp.lastIndexOf(" ") + 1, temp.length());
                    }
                }
                if (shortName == null) throw new Exception("Unable to retrieve windows short name for path component: " + file.getName());
                VWDebug.logInfo("Short Name: " + shortName);
            } else {
                shortName = parentFile != null ? file.getName() : file.getPath();
            }
            String shortPath = parentPath + shortName;
            if (map == null) return shortPath;
            map.put(path, shortPath);
            return shortPath;
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while retrieving short path for: " + path);
            return path;
        }
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isLocalHost(String hostName) throws UnknownHostException {
        return VWTaskUtil.isLocalHost(hostName, null);
    }

    public static boolean isLocalHost(String hostName, String explicitLocalHost) throws UnknownHostException {
        String method = "isLocalHost";
        InetAddress implicitLocalHostAddress = InetAddress.getLocalHost();
        InetAddress hostAddress = InetAddress.getByName(hostName);
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
        logger.finest(m_className, method, "Host name: " + hostName);
        logger.finest(m_className, method, "Host name IP address: " + hostAddress.getHostAddress());
        logger.finest(m_className, method, "Implicit local host address: " + implicitLocalHostAddress.getHostAddress());
        logger.finest(m_className, method, "Explicit local host : " + explicitLocalHost);
        if (hostAddress.isLoopbackAddress()) {
            logger.finest(m_className, method, "Is loopback address");
            return true;
        }
        if (hostAddress.equals(implicitLocalHostAddress)) {
            logger.finest(m_className, method, "Is implicit local host address");
            return true;
        }
        if (explicitLocalHost != null && !explicitLocalHost.equals("")) {
            String[] hosts = explicitLocalHost.split(",");
            for (int i = 0; i < hosts.length; ++i) {
                String host = hosts[i];
                try {
                    ips.addAll(Arrays.asList(InetAddress.getAllByName(host)));
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, m_className, method, "Exception while fetch IP's for explicity local host: " + host, ex);
                }
            }
            logger.finest(m_className, method, "Explicit local host IP addresses:");
            for (InetAddress ip : ips) {
                logger.finest(m_className, method, ip.getHostAddress());
            }
        } else {
            ips.addAll(Arrays.asList(InetAddress.getAllByName(implicitLocalHostAddress.getHostName())));
            logger.finest(m_className, method, "Implicit local host IP addresses:");
            for (InetAddress ip : ips) {
                logger.finest(m_className, method, ip.getHostAddress());
            }
        }
        for (InetAddress ip : ips) {
            if (!hostAddress.equals(ip)) continue;
            logger.finest(m_className, method, "Is local host: " + ip.getHostAddress());
            return true;
        }
        logger.finest(m_className, method, "Not local host.");
        return false;
    }

    public static void updateComponentOrientation(Component component) {
        try {
            if (component != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFile(String path) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(path);
            props.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(Properties props, String path) throws FileNotFoundException, IOException {
        FileOutputStream propFile = null;
        try {
            propFile = new FileOutputStream(path, false);
            props.store(propFile, null);
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        OS_TYPE_UNDEFINED = OperatingSystem.OS_TYPE_UNDEFINED;
        OS_TYPE_WINDOWS = OperatingSystem.OS_TYPE_WINDOWS;
        OS_TYPE_AIX = OperatingSystem.OS_TYPE_AIX;
        OS_TYPE_HP = OperatingSystem.OS_TYPE_HP;
        OS_TYPE_SOLARIS = OperatingSystem.OS_TYPE_SOLARIS;
        logger = Logger.getLogger("filenet.vw.apps.taskman");
        m_className = VWTaskUtil.class.getName();
    }
}

